/*
 * StringConversion.h
 *
 * Created 8/12/2009 By Johnny Huynh
 *
 * Version 00.00.01 8/12/2009
 *
 * Copyright Information:
 * All content copyright  2009 Johnny Huynh. All rights reserved.
 */
 
 #ifndef STRING_CONVERSION_H
 #define STRING_CONVERSION_H

 #include <string>
 #include <sstream>
 #include <stdio.h>
 
 namespace StringConversion
 {
    template <typename T> inline std::string to_str( const T& elem );
    inline int to_int( const std::string& str );
 }
 
 /**
  * to_str() returns a string representation of the specified element.
  *
  * @param (const T&) elem
  * @return std::string
  */
 template <typename T>
 inline std::string StringConversion::to_str( const T& elem )
 {
    //#include <stdio.h>
    //char c_string[50];
    //sprintf( c_string, "%d", elem );
    //return LPCTSTR( c_string );
    
    std::ostringstream oss;
    oss << elem;
    return oss.str();
 }
 
 /**
  * to_int() returns the first integer appearing the specified string.
  *
  * @param (const std::string&) str
  * @return int
  */
 inline int StringConversion::to_int( const std::string& str )
 {
    int result;
    
    sscanf( str.c_str(), "%d", &result );
    return result;
 }

 #endif // STRING_CONVERSION_H